# Smart Folders

Smart folders is a feature new to Deep Security 10.0 that enables you to filter and group your computers by their attributes. You can learn more about the feature from the [Deep Security Help Center](https://help.deepsecurity.trendmicro.com/Manage-Components/dynamically-grouping-computers-with-smart-folders.html).

## Smart folder concepts
A smart folder is a collection of queries for filtering computers. These queries are contained in one or more query groups. Each query has a key, an operator, and a value for filtering computers. Some queries may have a secondary operator and/or a secondary value depending on the property being filtered.

*Note: In the Deep Security Manager console a query is referred to as a rule and a query group is referred to as a rule group.*

## Authentication and authorization
All smart folder requests must be linked with a Deep Security Manager session. First authenticate with the Deep Security Manager to obtain a session ID and then include the session ID in a cookie parameter called `sID` when you make your requests.

## Creating a new smart folder
For our first task, let's create a smart folder that will show all of the Microsoft Windows computers activated in the Deep Security Manager. To do this we'll create a single rule with the `CONTAINS` operator so that the rule will match on any version of Windows. The response will return the ID of the created smart folder if the request was successful.

### API endpoint
```
POST /rest/smart-folders
```

### Example request body
```json
{  
   "CreateSmartFolderRequest": {  
      "name":"Test smart folder",
      "queryGroups": [  
         {  
            "query": [  
               {  
                  "key":"GENERAL_OS",
                  "operator":"CONTAINS",
                  "value":"Windows"
               }
            ]
         }
      ]
   }
}
```

### Example response body
```json
{
  "CreateSmartFolderResponse": {
    "smartFolderID": 111
  }
}
```

## Showing the computers in a smart folder
Now that we have a smart folder let's get the computers (called hosts in the Deep Security API) that are part of our new smart folder.

### API endpoint
```
GET /rest/smart-folders/111/hosts
```

### Example response body
```json
{
  "ListHostsResponse": {
    "hosts": [
      {
        "id": 100,
        "hostname": "172.31.24.183",
        "displayname": "Test Computer",
        "description": "This is a test computer",
        "created": 1475770754800,
        "lastModified": 1476469457193,
        "lastUpdateAttempt": null,
        "agentReportedVersion": "10.0.0.0",
        "externalId": "",
        "instanceId": "i-00000000000000000",
        "lastIpUsed": "",
        "platform": "Microsoft Windows Server 2008 R2 (64 bit)",
        "hostGroupId": 100,
        "policy": {
          "id": 2,
          "name": "Windows"
        }
      }
    ]
  }
}
```

## Updating a smart folder
Let's update our smart folder to add another rule that will search for Ubuntu computers as well as the Windows computers that are currently in the smart folder.

### API endpoint
```
POST /rest/smart-folders/11
```

### Example request body
```json
{  
   "UpdateSmartFolderRequest":{  
      "name":"Updated test smart folder",
      "queryGroups":[  
         {  
            "query":[  
               {  
                  "key":"GENERAL_OS",
                  "operator":"CONTAINS",
                  "value":"Windows"
               },
               {  
                  "key":"GENERAL_OS",
                  "operator":"CONTAINS",
                  "value":"Ubuntu"
               }
            ],
            "comparison":"OR"
         }
      ]
   }
}
```
The API should return `204 No Content` after successfully updating the smart folder.

## Creating a child smart folder
We now have a smart folder that will show all Windows and Ubuntu computers. Next, let's filter those computers even further by creating a child smart folder. A child smart folder creates a more focused search by applying additional criteria to the search results of the parent smart folder. We'll search for an IP range between `10.0.0.0` and `10.1.0.0`.

### API endpoint
```
POST /rest/smart-folders
```

### Example request body
```json
{  
   "CreateSmartFolderRequest":{  
      "name":"Test child smart folder",
      "parent": 111,
      "queryGroups": [  
         {  
            "query": [  
               {  
                  "key":"GENERAL_IP",
                  "operator":"IN_RANGE",
                  "value":"10.0.0.0",
                  "secondaryValue":"10.1.0.0"
               }
            ]
         }
      ]
   }
}
```

### Example response body
```json
{
  "CreateSmartFolderResponse": {
    "smartFolderID": 112
  }
}
```

## AWS tag key child folders
One of the most useful smart folder features for organizations with computers in the Amazon Web Services Elastic Compute Cloud is AWS tag-based child smart folders. Using this functionality you can automatically create child smart folders for each value of a specific AWS tag. Let's create a new smart folder with a set of child smart folders based on the values of the AWS tag named `Environment`.

### API endpoint
```
POST /rest/smart-folders
```

### Example request body
```json
{  
   "CreateSmartFolderRequest":{  
      "name":"Test AWS tag sub folders",
      "awsTagFoldersNameKey":"Environment",
      "queryGroups": []
   }
}
```

# Example response body
```json
{
  "CreateSmartFolderResponse": {
    "smartFolderID": 113
  }
}
```

## Get smart folder details
We can see the child smart folders created from the AWS tag by getting the details of the parent smart folder.

### API endpoint
```
GET /rest/smart-folders/111
```

### Example response body
```json
{
  "SmartFolder": {
    "smartFolderId": 113,
    "name": "Test AWS tag sub folders",
    "childSmartFolders": [
      {
        "smartFolderId": 114,
        "name": "Prod",
        "parentSmartFolderId": 113,
        "childSmartFolders": [],
        "type": 3
      },
      {
        "smartFolderId": 115,
        "name": "RC",
        "parentSmartFolderId": 113,
        "childSmartFolders": [],
        "type": 3
      },
      {
        "smartFolderId": 116,
        "name": "Dev",
        "parentSmartFolderId": 113,
        "childSmartFolders": [],
        "type": 3
      },
      {
        "smartFolderId": 117,
        "name": "Staging",
        "parentSmartFolderId": 113,
        "childSmartFolders": [],
        "type": 3
      },
      {
        "smartFolderId": 118,
        "name": "Production",
        "parentSmartFolderId": 113,
        "childSmartFolders": [],
        "type": 3
      },
      {
        "smartFolderId": 119,
        "name": "Development",
        "parentSmartFolderId": 113,
        "childSmartFolders": [],
        "type": 3
      }
    ],
    "type": 2,
    "queryGroups": [],
    "awsTagFoldersNameKey": "Environment",
    "comparison": "AND"
  }
}
```

## Listing smart folders
If we don't know the smart folder ID and still want to see the child smart folders created by our AWS tag key, we can use a list command to show a summary of all the smart folders in the DSM.

### API endpoint
```
GET /rest/smart-folders
```

# Example response body
```json
{
  "ListSmartFoldersResponse": {
    "smartFolders": [
      {
        "smartFolderId": 113,
        "name": "Test AWS tag sub folders",
        "childSmartFolders": [
          {
            "smartFolderId": 116,
            "name": "Dev",
            "parentSmartFolderId": 113,
            "childSmartFolders": [],
            "type": 3
          },
          {
            "smartFolderId": 119,
            "name": "Development",
            "parentSmartFolderId": 113,
            "childSmartFolders": [],
            "type": 3
          },
          {
            "smartFolderId": 114,
            "name": "Prod",
            "parentSmartFolderId": 113,
            "childSmartFolders": [],
            "type": 3
          },
          {
            "smartFolderId": 118,
            "name": "Production",
            "parentSmartFolderId": 113,
            "childSmartFolders": [],
            "type": 3
          },
          {
            "smartFolderId": 115,
            "name": "RC",
            "parentSmartFolderId": 113,
            "childSmartFolders": [],
            "type": 3
          },
          {
            "smartFolderId": 117,
            "name": "Staging",
            "parentSmartFolderId": 113,
            "childSmartFolders": [],
            "type": 3
          }
        ],
        "type": 2
      },
      {
        "smartFolderId": 111,
        "name": "Updated Test smart folder",
        "childSmartFolders": [
          {
            "smartFolderId": 112,
            "name": "Test Child smart folder",
            "parentSmartFolderId": 111,
            "childSmartFolders": [],
            "type": 1
          }
        ],
        "type": 1
      }
    ]
  }
}
```
